"use strict";

// Add fetchers
fm.fpower = new Fetcher("fm.fpower", "powerThreePhase", "#powerThreePhasePower");
[
	{ page: "SFP", target: "#SFPSupply" },
	{ page: "SFP", target: "#SFPExhaust" }
].forEach((s) => fm.fpower.add(s));

fm.fhours = new Fetcher("fm.fhours", "runHours", "#runHoursPerYear");
[
	{ page: "SFP", target: "#SFPRunHours" },
	{ page: "yearEnergy", target: "#yearEnergyRunHours" }
].forEach((s) => fm.fhours.add(s));

// Efficiency Exhaust
fm.exhaust = new Calc("fm.exhaust", {
	o: { id: "#efficiencyExhaustOutdoor", f: (v) => {return (v.e + v.r * (v.x - 1)) / v.x;} },
	r: { id: "#efficiencyExhaustReturn", f: (v) => {return (v.x * v.o - v.e) / (v.x - 1);} },
	e: { id: "#efficiencyExhaustExhaust", f: (v) => {return v.r * (v.x * -1) + v.r + v.x * v.o;} },
	x: { id: "#efficiencyExhaustEfficiency", f: (v) => {return (v.r - v.e) / (v.r - v.o);} }
});

// Efficiency Supply
fm.supply = new Calc("fm.supply", {
	o: { id: "#efficiencySupplyOutdoor", f: (v) => {return (v.x * v.r - v.s) / (v.x - 1);} },
	r: { id: "#efficiencySupplyReturn", f: (v) => {return ((v.x - 1) * v.o + v.s) / v.x;} },
	s: { id: "#efficiencySupplySupply", f: (v) => {return (v.x * -1) * v.o + v.x * v.r + v.o;} },
	x: { id: "#efficiencySupplyEfficiency", f: (v) => {return (v.s - v.o) / (v.r - v.o);} }
});

// Air humidity
function getTemperature(mixingRatio, rH) {
	let logSVP = Math.log((101.3 * mixingRatio) / (mixingRatio * rH + 0.622 * rH));
	return ((-235 * logSVP - 115.6) / (logSVP - 16.64));
}

function getSVP(temperature) {
	return Math.exp(16.64 - 4026 / (temperature + 235));
	// return 0.61078 * Math.exp(17.27 * (temperature - 273.15) / (temperature - 35.85));
}

fm.humidity = new Calc("fm.humidity", {
	t: { id: "#humidityTemperature", c: ["d"], f: (v) => {return getTemperature(v.m, v.h);} },
	h: { id: "#humidityRH", c: ["d"], f: (v) => {return v.m * 101.3 / (getSVP(v.t) * (0.622 + v.m))} },
	m: { id: "#humidityMixingRatio", c: ["d"], f: (v) => {return 0.622 * v.h * getSVP(v.t) / (101.3 - v.h * getSVP(v.t));} },
	d: { id: "#humidityDewPoint", d: ["m"], f: (v) => {return getTemperature(v.m, 1) } }
});

// k-factor
fm.kfactor = new Calc("fm.kfactor", {
    k: { id: "#kFactorK", f: (v) => {return v.f / Math.sqrt(v.p);} },
    f: { id: "#kFactorAirflow", f: (v) => {return v.k * Math.sqrt(v.p);} },
    p: { id: "#kFactorPressure", f: (v) => {return v.f ** 2 / v.k ** 2;} }
});

// Affinity
fm.affinity = new Calc("fm.affinity", {
	f1: { id: "#affinityFlow1" },
	f2: { id: "#affinityFlow2", f: (v) => {return v.f1 / Math.sqrt(v.p1 / v.p2);} },
	p1: { id: "#affinityPressure1" },
	p2: { id: "#affinityPressure2", f: (v) => {return v.p1 / (v.f1 / v.f2) ** 2;} },
	p: { id: "#affinityPower", f: (v) => {
		let fact = (v.f1 && v.f2) ? (v.f1 / v.f2) ** 3 : Math.sqrt(v.p1 / v.p2) ** 3;
		return (1 / fact) - 1;} }
});

// Speed to Volume
fm.svolume = new Calc("fm.svolume", {
    s: { id: ".speedVolumeSpeed", f: (v) => {
		let a = v.d ? Math.PI * (v.d / 2) ** 2 : v.w * v.h;
		return v.f / a;} },
    w: { id: "#speedVolumeWidth", f: (v) => {return (v.f / v.s) / v.h;} },
    h: { id: "#speedVolumeHeight", f: (v) => {return (v.f / v.s) / v.w;} },
    d: { id: "#speedVolumeDiameter", f: (v) => {return (Math.sqrt((v.f / v.s) / Math.PI) * 2);} },
    f: { id: "#speedVolumeFlow", f: (v) => {
		let a = v.d ? Math.PI * (v.d / 2) ** 2 : v.w * v.h;
		return a * v.s;} }
});

function speedVolumeAdd() {
	let field = document.getElementById("speedVolumeSpeeds").firstElementChild.cloneNode(true);
	document.getElementById("speedVolumeSpeeds").appendChild(field);
}

function speedVolumeRemove() {
	if (document.getElementById("speedVolumeSpeeds").childElementCount > 1) {
		document.getElementById("speedVolumeSpeeds").lastElementChild.remove();
	}
}

// Ventilation
fm.ventflow = new Calc("fm.ventflow", {
    a: { id: "#ventilationArea", f: (v) => {return (v.f - v.p * 0.007) / 0.00035;} },
    p: { id: "#ventilationPeople", f: (v) => {return Math.floor((v.f - v.a * 0.00035) / 0.007);} },
    f: { id: "#ventilationFlow", f: (v) => {return 0.007 * v.p + 0.00035 * v.a;} },
    o: { id: "#ventilationOccupation" },
    c: { id: "#ventilationCO2", f: (v) => {return 0.0004 + (v.p * v.o) / v.f;} }
});

// Power
fm.power = new Calc("fm.power", {
	p: { id: "#powerOnePhasePower", f: (v) => {return v.v * v.i;} },
	v: { id: "#powerOnePhaseVoltage", f: (v) => {return v.p / v.i;} },
	i: { id: "#powerOnePhaseCurrent", f: (v) => {return v.p / v.v;} }
});

// Power three phase
fm.power3 = new Calc("fm.power3", {
	p: { id: "#powerThreePhasePower", f: (v) => {return v.v * v.i * 1.732 * v.pf;} },
	v: { id: "#powerThreePhaseVoltage", f: (v) => {return (v.p * 1.732) / (v.i * v.pf * 3);} },
	i: { id: ".powerThreePhaseCurrent", f: (v) => {return v.p / (1.732 * v.pf * v.v);} },
	pf: { id: "#powerThreePhasePF", f: (v) => {return (v.p * 1.732) / (v.i * v.v * 3)} }
});

// SFP
fm.sfp = new Calc("fm.sfp", {
    s: { id: "#SFPSupply" },
    e: { id: "#SFPExhaust" },
    f: { id: "#SFPAirflow" },
    sfp: { id: "#SFPSFP", f: (v) => {return (v.s + v.e) / v.f;} },
    h: { id: "#SFPRunHours" },
    y: { id: "#SFPYearEnergy", d: ["sfp"], f: (v) => {return v.sfp * v.f * v.h;} }
});

// Cable
fm.cable = new Calc("fm.cable", {
	u: { id: "#cableVoltage" },
	phase: { id: "#cablePhase", r: (v) => {putn(v.u.id, v.phase.val == 1 ? 230 : 400)} },
	i: { id: "#cableCurrent" },
	l: { id: "#cableLength" },
	a: { id: "#cableArea" },
	r: { id: "#cableResistance" },
	t: { id: "#cableTemp" },
	loss: { id: "#cableLoss", f: (v) => {
		if (v.phase == 1) {v.l = v.l * 2}; 
		let loss = v.l * ((v.r * 1.004 ** (v.t - 20)) / v.a) * v.i * v.phase;
		putn("#cableLossPercent", loss / v.u);
		putn("#cablePower", (v.u - loss) * v.i * v.phase);
		putn("#cablePowerLoss", loss * v.i * v.phase);
		return loss;} }
});

// QW
fm.qw = new Calc("fm.qw", {
    e: { id: "#qwEnergy", r: (v) => {
		putn(v.dt.id, v.f.val / v.e.val);
		putn(v.qw.id, v.e.val / v.f.val);
	} },
    f: { id: "#qwFlow", r: (v) => {
		putn(v.dt.id, v.f.val / v.e.val);
		putn(v.qw.id, v.e.val / v.f.val);
	} },
    qw: { id: "#qwQW", r: (v) => {
		putn(v.dt.id, 1 / v.qw.val);
	} },
    dt: { id: "#qwDT", r: (v) => {
		putn(v.qw.id, 1 / v.dt.val);
	} },
});

// Pre pressure
fm.pressure = new Calc("fm.pressure", {
    h: { id: "#prePressureHeight", r: (v) => {
    	let min = new Converter(v.h.val, "mVp").value;
    	putn(v.pp.id, min + 20000);
    	putn(v.wp.id, min + 50000);
    } },
    pp: { id: "#prePressurePre" },
    wp: { id: "#prePressureWorking" }
});

// Year Energy
fm.yeare = new Calc("fm.yeare", {
	f: { id: "#yearEnergyAirflow" },
	t: { id: "#yearEnergyRunHours" },
	ef: { id: "#yearEnergyEfficiency" },
	s: { id: "#yearEnergySupply" },
	a: { id: "#yearEnergyYearAverage" },
	e: { id: "#yearEnergyYearEnergy", f: (v) => {
		return v.f * fm.heatcap.air * v.t * (v.s - v.a) * (1 - v.ef);
	} }
});

// Water Energy
fm.watere = new Calc("fm.watere", {
	v: { id: "#waterEnergyVolume", f: (v) => {return v.e / (v.p * fm.heatcap.water60 * v.dt);} },
	p: { id: "#waterEnergyPercent", f: (v) => {return v.e / (v.v * fm.heatcap.water60 * v.dt);} },
	dt: { id: "#waterEnergyDeltaT", f: (v) => {return v.e / (v.p * fm.heatcap.water60 * v.v);} },
	e: { id: "#waterEnergyEnergy", f: (v) => {return v.v * v.p * fm.heatcap.water60 * v.dt;} }
});

// Valve to Flow and Power
fm.valve = new Calc("fm.valve", {
	kv: { id: "#valveFlowKv", f: (v) => {return Math.sqrt((v.f ** 2) / new Converter(v.p).to_unit("kPa"));} },
	p: { id: "#valveFlowPressure", f: (v) => {return new Converter((v.f ** 2) / (v.kv ** 2), "kPa").value;} },
	f: { id: "#valveFlowFlow", f: (v) => {
		return v.p ? v.kv * Math.sqrt(new Converter(v.p).to_unit("kPa")) : v.pw / (fm.heatcap.water60 * v.dt);
	} },
	dt: { id: "#valveFlowDeltaT", f: (v) => {return v.pw / (v.f * fm.heatcap.water60);} },
	pw: { id: "#valveFlowPower", f: (v) => {return v.f * fm.heatcap.water60 * v.dt;} }
});

// General flow to power
fm.flowpower = new Calc("fm.flowpower", {
    f: { id: "#flowPowerFlow", f: (v) => {return v.p / (getmedia("#flowPowerMedia") * (v.t2 - v.t1));} },
    t1: { id: "#flowPowerTemp1" },
    t2: { id: "#flowPowerTemp2", f: (v) => {return v.p / (v.f * getmedia("#flowPowerMedia")) + v.t1;} },
    p: { id: "#flowPowerPower", f: (v) => {return v.f * getmedia("#flowPowerMedia") * (v.t2 - v.t1);} },
});

// Pressure Drop
function darcy(flow, diameter, viscosity, density, roughness) {
	let area = Math.PI * (diameter / 2) ** 2;
	let reynolds = flow / (area * viscosity) * diameter;
	let speed = flow / area;
	let pressure;
	if (reynolds < 2300) {
		// Darcy-Weisbach equation for laminar flow
		pressure = (128 * viscosity * density * flow) / (Math.PI * diameter ** 4);
	} else {
		// Swamee-Jain equation for finding the Darcy-Weisbach friction factor
		let friction = 0.25 / Math.log10((roughness / diameter) / 3.7 + 5.74 / reynolds ** 0.9) ** 2;
		// Darcy-Weisbach general equation
		pressure = (friction * density * speed ** 2) / (2 * diameter);
	}
	return {
		speed: speed,
		pressure: pressure,
		reynolds: reynolds
	}
}

fm.pressuredrop = new Calc("fm.pressuredrop", {
	q: { id: "#pressureDropFlow" },
	d: { id: "#pressureDropDiameter" },
	t: { id: "#pressureDropTemperature" },
	p: { id: "#pressureDropPressure", f: (v) => {
		let media = document.getElementById("pressureDropMedia").value;
		let result = darcy(v.q, v.d, fm.viscosity[media](v.t), fm.density[media](v.t), 0.00001 );
		putn("#pressureDropSpeed", result.speed);
		putn("#pressureDropReynolds", result.reynolds);
		return result.pressure;} }
});

// U Value
fm.uvalue = new Calc("fm.uvalue", {
	o: { id: "#uValueOutside", f: (v) => {return (v.s + v.i * (v.r * v.u - 1)) / (v.r * v.u);} },
	i: { id: "#uValueInside", f: (v) => {return (v.s - v.o * v.r * v.u) / (1 - v.r * v.u);} },
	s: { id: "#uValueSurface", f: (v) => {return (v.o - v.i) * v.r * v.u + v.i;} },
	u: { id: "#uValueUValue", f: (v) => {return ((v.i - v.s) / v.r) / (v.i - v.o);} },
	r: { id: "#uValueRsi" },
	a: { id: "#uValueArea" },
	p: { id: "#uValuePower", d: ["u"], f: (v) => {return (v.i - v.o) * v.u * v.a;} }
});

// Convert
fm.conFlow = new Conv("fm.conFlow", [
	"#conFlowLS",
	"#conFlowLM",
	"#conFlowLH",
	"#conFlowM3S",
	"#conFlowM3H",
	"#conFlowM3M",
	"#conFlowM3Y"
]);

fm.conPower = new Conv("fm.conPower", [
	"#conPowerW",
	"#conPowerKW",
	"#conPowerKWHM",
	"#conPowerKWHY",
	"#conPowerHK"
]);

fm.conEnergy = new Conv("fm.conEnergy", [
	"#conEnergyKWH",
	"#conEnergyMWH",
	"#conEnergyMJ"
]);

fm.conPressure = new Conv("fm.conPressure", [
	"#conPresPA",
	"#conPresHPA",
	"#conPresKPA",
	"#conPresBAR",
	"#conPresMVP"
]);

fm.conTime = new Conv("fm.conTime", [
	"#conTimeS",
	"#conTimeM",
	"#conTimeH",
	"#conTimeD"
]);

fm.conTorque = new Conv("fm.conTorque", [
	"#conTorqueNm",
	"#conTorqueInlb",
	"#conTorqueFtlb"
]);

// Run Hours per year
fm.runh = new Calc("fm.runh", {
	h: { id: "#runHoursPerDay", f: (v) => {
		let weeks = v.nw < 0 ? Math.abs(v.nw) : 52.18 - v.nw;
		return ((v.y / weeks) - v.w) / v.d;
	} },
	d: { id: "#runHoursDaysPerWeek" },
	w: { id: "#runHoursPerWeek" },
	nw: { id: "#runHoursWeeks" },
	y: { id: "#runHoursPerYear", f: (v) => {
		let weeks = v.nw < 0 ? Math.abs(v.nw) : 52.18 - v.nw; 
		return weeks * (v.h * v.d + v.w);
	} }
});

// Savings
fm.savings = new Calc("fm.savings", {
	s: { id: "#savingsSavings", c: ["p"], f: () => {return getn(".savingsBeforeCase", false) - getn(".savingsAfterCase", false);} },
	p: { id: "#savingsPercent", d: ["s"], f: () => {return getn("#savingsSavings") / getn(".savingsBeforeCase", false);} }
});

fm.savingsPoints = {
	id: 1,
	cases: [],
	add: function(section) {
		let elem = document.getElementById("savingsTemplate").cloneNode(true);
		elem.id = `savingsCase${this.id}`;
		elem.style.display = "grid";
		elem.querySelector("#savingsTotal").classList.add(`${section}Case`);
		["savingsPower", "savingsTime", "savingsNumber", "savingsTotal"].forEach((e) => {
			elem.querySelector(`#${e}`).id = `${e}${this.id}`;
		});
		document.getElementById(section).appendChild(elem);
		elem.querySelector(".removeButton").setAttribute("onclick", `fm.savingsPoints.remove("${this.id}");`);
		fm.fhours.add({page: "savings", target: `#savingsTime${this.id}`});
		dataListener(elem);

		fm.savingsPoints.cases[this.id] = new Calc(`fm.savingsPoints.cases[${this.id}]`, {
			p: { id: `#savingsPower${this.id}` },
			t: { id: `#savingsTime${this.id}` },
			n: { id: `#savingsNumber${this.id}` },
			e: { id: `#savingsTotal${this.id}`, f: (v) => {return v.p * v.t * v.n;} }
		});
		this.id++;
	},
	remove: function(id) {
		document.querySelector(`#savingsCase${id}`).remove();
	}
}

fm.savingsPoints.add("savingsBefore");
fm.savingsPoints.add("savingsAfter");